--[[
No Teleport Mod for Farming Simulator 25

Author: André Buchmann & VertexDezign
Issues: https://github.com/VertexDezign/NoTeleport/issues

Feel free to open a pull reuests for enhancements or bugfixes.

FS25_NoTeleport © 2025 by André Buchmann & VertexDezign is licensed under CC BY-NC-ND 4.0. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-nd/4.0/
]]
NoTeleport = {}
NoTeleport.name = "NoTeleport"

-- Return false to disable overwritten function
function NoTeleport:disableFunction()
    return false
end

function NoTeleport:loadMapFinished()
    g_currentMission.isToggleVehicleAllowed = false
end

function NoTeleport.setMapInputContext(mapFrame)
    mapFrame.contextActions[InGameMenuMapFrame.ACTIONS.VISIT_PLACE].isActive = false
    mapFrame:updateContextInputBarVisibility()
end

function initNoTeleport()
    PlaceableHotspot.getBeVisited = Utils.overwrittenFunction(PlaceableHotspot.getBeVisited, NoTeleport.disableFunction)
    NPCHotspot.getBeVisited = Utils.overwrittenFunction(NPCHotspot.getBeVisited, NoTeleport.disableFunction)
    FerryHotspot.getBeVisited = Utils.overwrittenFunction(FerryHotspot.getBeVisited, NoTeleport.disableFunction)
    Enterable.getIsEnterableFromMenu = Utils.overwrittenFunction(Enterable.getIsEnterableFromMenu, NoTeleport.disableFunction)
    FSBaseMission.loadMapFinished = Utils.appendedFunction(FSBaseMission.loadMapFinished, NoTeleport.loadMapFinished)
    InGameMenuMapFrame.setMapInputContext = Utils.appendedFunction(InGameMenuMapFrame.setMapInputContext, NoTeleport.setMapInputContext)
end

-- Load as early as possible to override the "Enterable" methods
initNoTeleport()
